/*
Copyright (C) 2010 Edge-Core Networks
This software file (the "File") is owned and distributed by 
Edge-Core Networks under the following licensing terms.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston,
MA 02111-1307 USA
*/

#ifndef _UC_MGR_H
#define _UC_MGR_H

#include "ams_common.h"

#if 1 /*#ifdef CONFIG_AMS_UBOOT*/


#define SYS_HWCFG_RCS1_BASE							0xEA000000
#define SYS_HWCFG_RCS1_OFFSET						0x01
#define SYS_HWCFG_SDRAM_CONFIG_ADDR                 (SYS_HWCFG_RCS1_BASE + 0xD0004 * SYS_HWCFG_RCS1_OFFSET) /*0xFF0D0004*/

#define SYS_HWCFG_SDRAM_SIZE_MASK                   0x07    /* 00000111 */
#define SYS_HWCFG_SDRAM_SIZE_4M                     0x00    /* xxxxx000 */
#define SYS_HWCFG_SDRAM_SIZE_8M                     0x01    /* xxxxx001 */
#define SYS_HWCFG_SDRAM_SIZE_16M                    0x02    /* xxxxx010 */
#define SYS_HWCFG_SDRAM_SIZE_32M                    0x03    /* xxxxx011 */
#define SYS_HWCFG_SDRAM_SIZE_64M                    0x04    /* xxxxx100 */
#define SYS_HWCFG_SDRAM_SIZE_128M                   0x05    /* xxxxx101 */
#define SYS_HWCFG_SDRAM_SIZE_256M                   0x06    /* xxxxx110 */
#define SYS_HWCFG_SDRAM_SIZE_512M                   0x07    /* xxxxx111 */

#define SYS_ADPT_MAX_NBR_OF_UNIT_PER_STACK               8   /* Max number of units can be stacked togather   */
#define SYS_ADPT_MAX_NBR_OF_PORT_PER_UNIT                56  /* Max number of port can be installed in a unit */
#define SYS_ADPT_MAX_NBR_OF_TRUNK_PER_SYSTEM             32  /* Max number of trunk port can be setup per stack */

#define SYS_ADPT_TOTAL_NBR_OF_LPORT                             (SYS_ADPT_MAX_NBR_OF_UNIT_PER_STACK *       \
                                                                 SYS_ADPT_MAX_NBR_OF_PORT_PER_UNIT  +       \
                                                                 SYS_ADPT_MAX_NBR_OF_TRUNK_PER_SYSTEM)
#define SYS_ADPT_TOTAL_NBR_OF_BYTE_FOR_1BIT_PORT_LIST           ((SYS_ADPT_TOTAL_NBR_OF_LPORT + 7) / 8)
#define SYS_ADPT_TOTAL_NBR_OF_BYTE_FOR_2BIT_PORT_LIST           ((SYS_ADPT_TOTAL_NBR_OF_LPORT)*2 + 7) / 8)

#define SYS_ADPT_NBR_OF_BYTE_FOR_1BIT_UPORT_LIST                ((SYS_ADPT_MAX_NBR_OF_PORT_PER_UNIT + 7) / 8)

#define L_CVRT_GET_PTR(base_p, offset) ((void *)((unsigned char *)(base_p) + (int)(offset)))
#define L_ALIGN(addr,boundary)         (((unsigned long)(addr) + (boundary) - 1) & ~((boundary) - 1))
#define L_CVRT_GET_OFFSET(base_p, ptr) ((unsigned long)(ptr) - (unsigned long)(base_p))

#define CFG_AMS_UC_MGR_SIGNATURE      "_UC_MGR_"
#define CFG_AMS_UC_MGR_SIGNATURE_SIZE (sizeof(CFG_AMS_UC_MGR_SIGNATURE) - 1) /* no '\0' */

#define CFG_AMS_UC_MGR_INDEXS    64
#define CFG_AMS_UC_MGR_INDEX_MIN 0
#define CFG_AMS_UC_MGR_INDEX_MAX (CFG_AMS_UC_MGR_INDEXS - 1)

/* enum for switch external loopback test status in runtime - mikeliu.121004 */
enum EXTERNAL_STATUS_INDEX
{
    EXTERNAL_NOT_TEST = 0,
    EXTERNAL_TEST_FAIL,
    EXTERNAL_TEST_SUCESS
};

enum INDEX
{
   UC_MGR_SYS_INFO_INDEX = 0,
   UC_MGR_DOWNLOAD_INFO_INDEX,
   UC_MGR_SYSLOG_UC_NORMAL_INDEX,
   UC_MGR_SYSLOG_UC_FLASH_INDEX,
   UC_MGR_DHCP_INFO_INDEX,
   UC_MGR_PROVISION_RESTART_INFO_INDEX,
   UC_MGR_POST_RESULT_INFO_INDEX,
   UC_MGR_PROVISION_FILE_INFO_INDEX,
   UC_MGR_OEM_LOGO_INDEX,
   UC_MGR_LOOPBACK_TEST_RESULT_INDEX,
   UC_MGR_BOOT_REASON_CHECKING_INDEX,
   UC_MGR_DBG_BUF,
   UC_MGR_RESERVED_INDEX,
   UC_MGR_RESERVED_INDEX_13,
   UC_MGR_RESERVED_INDEX_14,
   UC_MGR_RESERVED_INDEX_15,
   UC_MGR_RESERVED_INDEX_16,
   UC_MGR_RESERVED_INDEX_17,
   UC_MGR_RESERVED_INDEX_18,
   UC_MGR_RESERVED_INDEX_19,
   UC_MGR_RESERVED_INDEX_20,
   UC_MGR_RESERVED_INDEX_21,
   UC_MGR_RESERVED_INDEX_22,
   UC_MGR_RESERVED_INDEX_23,
   UC_MGR_RESERVED_INDEX_24,
   UC_MGR_RESERVED_INDEX_25,
   UC_MGR_RESERVED_INDEX_26,
   UC_MGR_RESERVED_INDEX_27,
   UC_MGR_RESERVED_INDEX_28,
   UC_MGR_RESERVED_INDEX_29,
   UC_MGR_RESERVED_INDEX_30,
   UC_MGR_RESERVED_INDEX_31,
   UC_MGR_RESERVED_INDEX_32,
   UC_MGR_RESERVED_INDEX_33,
   UC_MGR_RESERVED_INDEX_34,
   UC_MGR_RESERVED_INDEX_35,
   UC_MGR_RESERVED_INDEX_36,
   UC_MGR_RESERVED_INDEX_37,
   UC_MGR_RESERVED_INDEX_38,
   UC_MGR_RESERVED_INDEX_39,
   UC_MGR_RESERVED_INDEX_40,
   UC_MGR_RESERVED_INDEX_41,
   UC_MGR_RESERVED_INDEX_42,
   UC_MGR_RESERVED_INDEX_43,
   UC_MGR_RESERVED_INDEX_44,
   UC_MGR_RESERVED_INDEX_45,
   UC_MGR_RESERVED_INDEX_46,
   UC_MGR_RESERVED_INDEX_47,
   UC_MGR_RESERVED_INDEX_48,
   UC_MGR_RESERVED_INDEX_49,
   UC_MGR_RESERVED_INDEX_50,
   UC_MGR_RESERVED_INDEX_51,
   UC_MGR_RESERVED_INDEX_52,
   UC_MGR_RESERVED_INDEX_53,
   UC_MGR_RESERVED_INDEX_54,
   UC_MGR_RESERVED_INDEX_55,
   UC_MGR_RESERVED_INDEX_56,
   UC_MGR_RESERVED_INDEX_57,
   UC_MGR_RESERVED_INDEX_58,
   UC_MGR_RESERVED_INDEX_59,
   UC_MGR_RESERVED_INDEX_60,
   UC_MGR_RESERVED_INDEX_61,
   UC_MGR_RESERVED_INDEX_62,
   UC_MGR_RESERVED_INDEX_63,
};

typedef struct
{
   unsigned char signature[CFG_AMS_UC_MGR_SIGNATURE_SIZE] ;
   unsigned long free_offset;
   unsigned long offset[CFG_AMS_UC_MGR_INDEXS];
   unsigned char data[0];
} UC_MEM_Header_T;

/* WARNING!!! A duplicate definition is in ams_ucmgr.h which is used by uboot.
 *            Any changes to UC_MGR_Sys_Info_T must also be synced to
 *            ams_ucmgr.h!
 */
typedef struct UC_MGR_Sys_Info_S /* total 64 bytes */
{
    unsigned long   magic_number;                                           /* to tell cold start or warm start             */
    unsigned long   *warm_start_entry;                                      /* entry of warm start                          */
    unsigned char   mac_addr[SYS_ADPT_MAC_ADDR_LEN];                        /* MAC address(len 6)                           */
    unsigned char   serial_no[SYS_ADPT_SERIAL_NO_STR_LEN + 1];              /* serial number(len 11+1)                      */
    unsigned char   mainboard_hw_ver[SYS_ADPT_HW_VER_STR_LEN + 1];          /* Mainboard board hardware version(len 5+1)    */
    unsigned char   manufacture_date[SYS_ADPT_MANUFACTURE_DATE_LEN + 1];        /* Product date, option to key in. 2001-10-31   */
    unsigned char   loader_ver[SYS_ADPT_FW_VER_STR_LEN + 1];                /* Loader software version(len 11+1)            */
    unsigned char   post_ver[SYS_ADPT_FW_VER_STR_LEN + 1];                  /* POST software version(len 11+1)              */
    unsigned char   runtime_fw_ver[SYS_ADPT_FW_VER_STR_LEN + 1];            /* runtime version(len 11+1)                    */
    unsigned char   sw_service_tag[SYS_ADPT_SERIAL_NO_STR_LEN + 1];         /* service tag serial number (len 11+1)         */
    unsigned char   model_number[SYS_ADPT_MODEL_NUMBER_LEN + 1];            /* Model number(len 15+1)                       */
    unsigned char   sw_chassis_service_tag[SYS_ADPT_SERIAL_NO_STR_LEN + 1]; /* service tag serial number (len 11+1)         */
    unsigned long   sw_identifier;
    unsigned long   project_id;
    unsigned long   board_id;
    unsigned long   baudrate;
    unsigned char   post_pass;                                              /* POST result: 0 or 1 */
    unsigned char   epld_version;                                           /* EPLD version */
    unsigned char   module_expected_runtime_fw_ver[SYS_ADPT_FW_VER_STR_LEN + 1]; /* For the multi-image header, used by loader to fill in module part runtime version */
    unsigned long   post_mode;                                              /* indicate which POST mode is selected, have a value defined in POST_MODE_E - mikeliu.160804 */
    unsigned char   switch_loopback_pass;                                   /* POST switch loopback result: 0(not tested), 1(fail) or 2(pass) - mikeliu.160804 */
    unsigned char   loader_customized_ver[SYS_ADPT_LOADER_CUSTOMIZED_VER_STR_LEN + 1]; /* Loader customzied software version(len 11+1)            */
    union
    {
        unsigned char   reserved[824];                                          /* reserved for future using, Jason suggestion  */
        struct
        {
            unsigned long   *boot_reason_address;                   /* this address which storages boot reason */
            unsigned long   software_build_time;
            unsigned char   check_ram_result;
            unsigned char   check_flash_result;
            unsigned char   check_i2c_result;
            unsigned char   check_pwrcable_result;
            unsigned char   burn_in_post_ever_failed;               /* this is used by diag in burn in post mode, 0:no post failure ever occurred 1:at least one post failure occurred */
            unsigned char   reserved[811];	
        } __attribute__((packed, aligned(1)))  ext_info;
    } __attribute__((packed, aligned(1)))  raw;
    unsigned short  check_sum;                                              /* check sum to protect mac and serial no.      */
} UC_MGR_Sys_Info_T;

#define boot_reason_addr raw.ext_info.boot_reason_address

#ifdef CONFIG_AMS_UCMGR_SHOWLOG
typedef struct UC_MGR_KERNEL_DBG_BUF_S
{
    unsigned long start;
    unsigned long end;
    unsigned long size;
} UC_MGR_KERNEL_DBG_BUF_T;

#define UC_MGR_KERNEL_DBG_BUF_SIZE (512*1024)
#endif

typedef struct UC_MGR_Download_Info_S
{
    unsigned long *download_ptr;  /* download start pointer   */
    unsigned long download_size;  /* download size            */
    unsigned long check_sum;      /* check sum                */
} UC_MGR_Download_Info_T;

/* EXPORTED ROUTINE DECLARACTION
 */


/* FUNCTION NAME: UC_MGR_InitiateProcessResources
 * PURPOSE: This function is used to initialize the un-cleared memory management module.
 * INPUT:   None.
 * OUTPUT:  None.
 * RETUEN:  TRUE    -- successful.
 *          FALSE   -- unspecified failure, system error.
 * NOTES:   Initialize the ucmgmt module and create semphore.
 *
 */
BOOL UC_MGR_InitiateProcessResources(void);


/* FUNCTION NAME: UC_MGR_Allocate
 * PURPOSE: This function is used to allocate memory from uc memory for need module.
 * INPUT:   alloc_index -- each data object must correspond a unique index value,
 *                         vaule range: 0 .. (SYS_ADPT_MAX_UC_BUFFER_POINT_INDEX_NUM-1).
 *          alloc_size  -- bytes to allocate.
 *          boundary    -- must order of 2
 * OUTPUT:  None.
 * RETUEN:  not 0   -- successful.
 *          0       -- unspecified failure, no free memory.
 * NOTES:   Must be called after UC_MGR_InitiateProcessResources.
 *
 */
void* UC_MGR_Allocate(unsigned long alloc_index, unsigned long alloc_size, unsigned long boundary);


/* FUNCTION NAME: UC_MGR_GetSysInfo
 * PURPOSE: This function is used to get system information from uc memory.
 * INPUT:   *sys_info   -- output buffer of the system information.
 * OUTPUT:  *sys_info   -- the system information.
 * RETUEN:  TRUE    -- successful
 *          FALSE   -- failure
 * NOTES:   1. The function should be called by stktplg.
 *          2. The function should be called after the memory be allocated.
 *          3. If the memory is not allocated, the function will return FALSE.
 *
 */
BOOL UC_MGR_GetSysInfo(UC_MGR_Sys_Info_T *p_sysinfo);


/* FUNCTION NAME: UC_MGR_SetSysInfo
 * PURPOSE: This function is used to set system information to uc memory.
 * INPUT:   sys_info    -- setting value of the system information.
 * OUTPUT:  None.
 * RETUEN:  TRUE    -- successful
 *          FALSE   -- failure
 * NOTES:   1. The function should be called by prom code/load code.
 *          2. The function should be called after the memory be allocated.
 *          3. If the memory is not allocated, the function will return FALSE.
 *
 */
BOOL UC_MGR_SetSysInfo(UC_MGR_Sys_Info_T *p_sysinfo);

BOOL UC_MGR_GetReloadModeInfo(unsigned long *p_reload_mode);
BOOL UC_MGR_SetReloadModeInfo(unsigned long reload_mode);


/* FUNCTION NAME: UC_MGR_GetDownloadInfo
 * PURPOSE: This function is used to get download information from uc memory.
 * INPUT:   *download_info   -- output buffer of the download information.
 * OUTPUT:  *download_info   -- the download information.
 * RETUEN:  TRUE    -- successful
 *          FALSE   -- failure
 * NOTES:   1. The function should be called by download module.
 *          2. The function should be called after the memory be allocated.
 *          3. If the memory is not allocated, the function will return FALSE.
 *
 */
BOOL UC_MGR_GetDownloadInfo(UC_MGR_Download_Info_T *p_downloadinfo);


/* FUNCTION NAME: UC_MGR_SetDownloadInfo
 * PURPOSE: This function is used to set download information to uc memory.
 * INPUT:   download_info    -- setting value of the download information.
 * OUTPUT:  None.
 * RETUEN:  TRUE    -- successful
 *          FALSE   -- failure
 * NOTES:   1. The function should be called by prom code/load code.
 *          2. The function should be called after the memory be allocated.
 *          3. If the memory is not allocated, the function will return FALSE.
 *
 */
BOOL UC_MGR_SetDownloadInfo(UC_MGR_Download_Info_T *p_downloadinfo);

/* FUNCTION NAME: UC_MGR_GetUcMemStartAddr
 * PURPOSE: This function is used to get UC memory start address.
 * INPUT:   none
 * OUTPUT:  none
 * RETUEN:  UC memory start address
 *
 * NOTES:
 *
 */
unsigned long UC_MGR_GetUcMemStartAddr(void);

/* FUNCTION NAME: UC_MGR_GetUcMemEndAddr
 * PURPOSE: This function is used to get UC memory end address.
 * INPUT:   none
 * OUTPUT:  none
 * RETUEN:  UC memory end address
 *
 * NOTES:
 *
 */
unsigned long UC_MGR_GetUcMemEndAddr(void);


/*
 * FUNCTION NAME: UC_MGR_Init
 * PURPOSE: This function is used to initialize the un-cleared memory management module.
 * INPUT:   None.
 * OUTPUT:  None.
 * RETUEN:  TRUE    -- successful.
 *          FALSE   -- unspecified failure, system error.
 * NOTES:   Initialize the ucmgmt module.
 *          If the signature is correct, don't init the uc memory and use old one,
 *          this case may be warmboot, or watchdog reset. We need to keep the log information
 *          and store the log to logfile after reboot.
 */
BOOL UC_MGR_Init(void);

/*
 * FUNCTION NAME: UC_MGR_Reset
 * PURPOSE: This function is used to reset the un-cleared memory.
 * INPUT:   None.
 * OUTPUT:  None.
 * RETUEN:  None.
 * NOTES:   Clear the un-cleared memory include the header.
 *          After calling this function, the UC is invalid.
 */
void UC_MGR_Reset(void);

#endif

#endif

